package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * XXXX
 * Inserte aqu� la descripci�n del tipo.
 * Fecha de creaci�n: (04/06/07)
 */
public class P06B64T00DAO {

	static private P06B64T00DAO instance = null;
	private Byte filtro = null;

	public static P06B64T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B64T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B64T00DAO();
	                }
	          }
	     }
	     return instance;
	}

	/**
    * Modifica un registro de la BD
    * @param obj.
    *            objeto a modificar
    * @return String -> El numero de expediente modificado
    * @throws SQLException
    */
	public void update(int correlativo, byte estadoAtencionPeticion) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B64T00DAO-update");

		PreparedStatement lstm  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = UPDATE_ESTADO;
        lstm = lconConexion.prepareStatement(sql);

    	lstm.setByte(1, estadoAtencionPeticion);
    	lstm.setInt(2, correlativo);
    	lstm.executeUpdate();
    	//Cierro recursos
    	lstm.close();
    	lconConexion.close();
        P06BLog.send(2,this, "Fin P06B64T00DAO-update: correlativo: " + correlativo + ", estado = " + estadoAtencionPeticion);
	}

	/**
    * Obtiene el objeto asociado a los parametros de entrada
    * @return objeto que cumple los parametros, o null si no lo encuentra
	 * @throws SQLException
	* @throws Exception
    */
	public P06B64T00Datatype selectByPK(int correlativo) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B64T00Datatype-selectByPK");
		P06B64T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setInt(1, correlativo);
        	lrst = lstm.executeQuery();
	        if(lrst.next()) {
	        	obj = new P06B64T00Datatype();
	        	obj.setCorrelativo(correlativo);
			    obj.setFecha(lrst.getDate(P06BTablas.P06B_P06B64_AP_FECHA));
			    obj.setMensaje(lrst.getString(P06BTablas.P06B_P06B64_AP_MENSAJE));
			    obj.setContextSubmissionEvent(lrst.getString(P06BTablas.P06B_P06B64_AP_CONTEXTSUBMISSIONEVENT));
			    obj.setEjgvDocument(lrst.getString(P06BTablas.P06B_P06B64_AP_EJGVDOCUMENT));
			    obj.setIdSolicitudTramitagune(lrst.getString(P06BTablas.P06B_P06B64_AP_IDSOL_TRAMITAGUNE));
			    obj.setFinalizada(lrst.getBoolean(P06BTablas.P06B_P06B64_AP_FINALIZADA));
			    obj.setMensajeError(lrst.getString(P06BTablas.P06B_P06B64_AP_MENSAJEERROR));
			    obj.setRegistryNumber(lrst.getString(P06BTablas.P06B_P06B64_AP_REGISTRYNUMBER));
			    obj.setbActualizarDomicilioSocial(lrst.getBoolean(P06BTablas.P06B_P06B64_AP_ACTDOMSOC));
			    obj.setbActualizarCapitalSocial(lrst.getBoolean(P06BTablas.P06B_P06B64_AP_ACTCAPSOC));
			    obj.setbActualizarAdministradores(lrst.getBoolean(P06BTablas.P06B_P06B64_AP_ACTADM));
			    obj.setbActualizarOrganoDireccion(lrst.getBoolean(P06BTablas.P06B_P06B64_AP_ACTORGDIR));
			    obj.setbActualizarAtencionDefensaCliente(lrst.getBoolean(P06BTablas.P06B_P06B64_AP_ACTATENCDEFCLIEN));
			    obj.setbActualizarCapacidadFinanciera(lrst.getBoolean(P06BTablas.P06B_P06B64_AP_ACTCAPFINAN));
			    obj.setbActualizarEntidadesVinculadas(lrst.getBoolean(P06BTablas.P06B_P06B64_AP_ACTENTVINC));
			    obj.setEstado(lrst.getByte(P06BTablas.P06B_P06B64_AP_ESTADO));
			    obj.setProcedimiento(lrst.getString(P06BTablas.P06B_P06B64_AP_PROCEDIMIENTO));
			    obj.setExpediente(lrst.getString(P06BTablas.P06B_P06B64_AP_NUMEXP));
	        }
	        P06BLog.send(2,this, "Fin P06B64T00Datatype-selectByPK");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	        throw e;
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return obj;
	}

	/**
    * Obtiene el objeto asociado a los parametros de entrada
    * @return objeto que cumple los parametros, o null si no lo encuentra
	 * @throws SQLException
	* @throws Exception
    */
	public ArrayList<P06B64T00Datatype> selectListado() throws SQLException{
		P06BLog.send(2,this, "Inicio P06B64T00Datatype-selectListado");
		ArrayList<P06B64T00Datatype> p06BInformeOtroDECDet2 = new ArrayList<P06B64T00Datatype>();
		P06B64T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = getStrListadoAtencionPeticiones("");
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lrst = lstm.executeQuery();
            int indLinea = 0;
	        while(lrst.next()) {
	        	obj = new P06B64T00Datatype();
	        	obj.setCorrelativo(lrst.getInt(P06BTablas.P06B_P06B64_AP_CORRELATENCPETIC));
//			    obj.setFecha(lrst.getDate(P06BTablas.P06B_P06B64_AP_FECHA));
			    obj.setFecha(lrst.getTimestamp(P06BTablas.P06B_P06B64_AP_FECHA));
			    obj.setProcedimiento(lrst.getString(P06BTablas.P06B_P06B64_AP_PROCEDIMIENTO));
			    obj.setRegistryNumber(lrst.getString(P06BTablas.P06B_P06B64_AP_REGISTRYNUMBER));
			    obj.setExpediente(lrst.getString(P06BTablas.P06B_P06B64_AP_NUMEXP));
			    obj.setFinalizada(lrst.getBoolean(P06BTablas.P06B_P06B64_AP_FINALIZADA));
			    obj.setEstado(lrst.getByte(P06BTablas.P06B_P06B64_AP_ESTADO));
//			    int longitud = 0;
//			    if (lrst.getString(P06BTablas.P06B_P06B64_AP_MENSAJEERROR)!=null){
//			    	if (lrst.getString(P06BTablas.P06B_P06B64_AP_MENSAJEERROR).length()>300){
//			    		longitud = 300;
//			    	}else{
//			    		longitud = lrst.getString(P06BTablas.P06B_P06B64_AP_MENSAJEERROR).length();
//			    	}
//			    }
//			    obj.setMensajeError((lrst.getString(P06BTablas.P06B_P06B64_AP_MENSAJEERROR)==null?"":lrst.getString(P06BTablas.P06B_P06B64_AP_MENSAJEERROR).substring(0,longitud)));
			    obj.setMensajeError((lrst.getString(P06BTablas.P06B_P06B64_AP_MENSAJEERROR)==null?"":lrst.getString(P06BTablas.P06B_P06B64_AP_MENSAJEERROR)));
        		p06BInformeOtroDECDet2.add(indLinea, obj);
        		indLinea++;
	        }
	        P06BLog.send(2,this, "Fin P06B64T00Datatype-selectListado");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	        throw e;
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return p06BInformeOtroDECDet2;
	}

	public String getStrListadoAtencionPeticiones(HttpServletRequest request, String where){
		filtro = Byte.parseByte((String)request.getSession().getAttribute(P06BConstantes.P06B_FILTRO_APT));
		return getStrListadoAtencionPeticiones(where);
	}


	public String getStrListadoAtencionPeticiones(String where){
		if (filtro==P06BConstantes.P06B_FILTRO_APT_ERRORORECOGIDA){
			if ("".equals(where.trim())){
				where = where + "WHERE ";
			}else{
				where = where + "AND ";
			}
			where = where + "(" + P06BTablas.P06B_P06B64_AP_FINALIZADA + "=0 AND " +
			P06BTablas.P06B_P06B64_AP_ESTADO + "=" + P06BConstantes.P06B_AP_ESTADO_PORCORREGIR + ") OR (" +
			P06BTablas.P06B_P06B64_AP_FINALIZADA + "=1 AND (" +
			P06BTablas.P06B_P06B64_AP_ESTADO + "=" + P06BConstantes.P06B_AP_ESTADO_ENSISTEMA + " OR " +
			P06BTablas.P06B_P06B64_AP_ESTADO + "=" + P06BConstantes.P06B_AP_ESTADO_PORREVISAR + "))";
		}
		return SELECT_LISTADO + " " + where + " ORDER BY " + P06BTablas.P06B_P06B64_AP_CORRELATENCPETIC + " DESC";
	}

	/**
	 * @return the filtro
	 */
	public Byte getFiltro() {
		return filtro;
	}

	/**
	 * @param filtro the filtro to set
	 */
	public void setFiltro(Byte filtro) {
		this.filtro = filtro;
	}

	private static String UPDATE_ESTADO =
		"UPDATE  "+ P06BTablas.P06B_P06B64T00_TABLA + " SET " +
		P06BTablas.P06B_P06B64_AP_ESTADO + "= ? " +
		" WHERE " + P06BTablas.P06B_P06B64_AP_CORRELATENCPETIC + "= ?";

	private static String SELECT_LISTADO =
		"SELECT  " +
		P06BTablas.P06B_P06B64_AP_CORRELATENCPETIC + ", " +
		P06BTablas.P06B_P06B64_AP_FECHA + ", " +
		P06BTablas.P06B_P06B64_AP_PROCEDIMIENTO + ", " +
		P06BTablas.P06B_P06B64_AP_REGISTRYNUMBER + ", " +
		P06BTablas.P06B_P06B64_AP_NUMEXP + ", " +
		P06BTablas.P06B_P06B64_AP_FINALIZADA + ", " +
		P06BTablas.P06B_P06B64_AP_ESTADO + ", " +
		P06BTablas.P06B_P06B64_AP_MENSAJEERROR + " " +
		"FROM "+ P06BTablas.P06B_P06B64T00_TABLA;

	private static String SELECTALL_BY_PK =
		"SELECT "
		+ P06BTablas.P06B_P06B64_AP_FECHA + ", "
		+ P06BTablas.P06B_P06B64_AP_MENSAJE + ", "
		+ P06BTablas.P06B_P06B64_AP_CONTEXTSUBMISSIONEVENT + ", "
		+ P06BTablas.P06B_P06B64_AP_EJGVDOCUMENT + ", "
		+ P06BTablas.P06B_P06B64_AP_IDSOL_TRAMITAGUNE + ", "
		+ P06BTablas.P06B_P06B64_AP_FINALIZADA + ", "
		+ P06BTablas.P06B_P06B64_AP_MENSAJEERROR + ", "
		+ P06BTablas.P06B_P06B64_AP_REGISTRYNUMBER + ", "
		+ P06BTablas.P06B_P06B64_AP_ACTDOMSOC + ", "
		+ P06BTablas.P06B_P06B64_AP_ACTCAPSOC + ", "
		+ P06BTablas.P06B_P06B64_AP_ACTADM + ", "
		+ P06BTablas.P06B_P06B64_AP_ACTORGDIR + ", "
		+ P06BTablas.P06B_P06B64_AP_ACTATENCDEFCLIEN + ", "
		+ P06BTablas.P06B_P06B64_AP_ACTCAPFINAN + ", "
		+ P06BTablas.P06B_P06B64_AP_ACTENTVINC + ", "
		+ P06BTablas.P06B_P06B64_AP_ESTADO + ", "
		+ P06BTablas.P06B_P06B64_AP_PROCEDIMIENTO + ", "
		+ P06BTablas.P06B_P06B64_AP_NUMEXP +
		" FROM " + P06BTablas.P06B_P06B64T00_TABLA
		+ " WHERE " + P06BTablas.P06B_P06B64_AP_CORRELATENCPETIC + "= ?";

}
